#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'
require 'watir-scroll'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative './request_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/request_appointment_detail'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../module/database/MongoUtility'
require_relative '../../helper/modal'


describe '[Story VAR-1734: Appointment Requests - Utility Integration - Primary Care]' do
  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @new_request = NewAppointmentRequest.new(@driver)
    @detail = RequestAppointmentDetail.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @modal = Modal.new(@driver)
    @today = getDateNthDaysFromNow(0, "%m/%d/%Y")
    TITLE = "Appointments/Requests"

    #mongo
    @db = connectToMongoDB("var-utility")
    #restoreCollection("clinical-services", "var-utility", "clinical_services_customized.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingDisabled.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    @patientID = "1006088937V099668"
    @patientID2 = "1113138327"
    deletePatientData(@patientID)
    deletePatientData(@patientID2)
    @common.loginEndsOnHome(MockUser03)
    @common.selectAddAppointmentButton("VA")

  end

  after(:all) do
    @driver.close
    #restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
  end

  context 'AC#VAR-4157| TC#VAR-4158: Request - Primary Care - Utility Integration' do
    it "Request - Primary Care Supported: Submit a Request to VA Scheduliner" do

      @new_request.selectTypeOfCare(PRIMARY_CARE)
      @new_request.selectState("523")
      @new_request.selectLocation("523")
      @common.waitWhileSpinnerPresent
      expected_content =[\
                        "Step 4: Scheduling Method",
                        "The location you selected supports the following scheduling methods:",
                        "* Select a scheduling method:",
                        "Schedule Myself",
                        "You must have an assigned PACT team to directly schedule appointments. Please contact your facility for assistance.",
                        "Submit a Request to VA Scheduler",
      ]

      actual_content = @new_request.scheduling_method_section.split("\n")
      compareContents(expected_content, actual_content)

    end

    it "If only one scheduling method is available and enabled, display that radio button choice as selected by default.  " do
      restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingDisabled.json", @db)
      restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
      @new_request.selectTypeOfCare(AUDIOLOGY)
      @new_request.selectState("523")
      @new_request.selectLocation("523")
      @common.waitWhileSpinnerPresent
      expect(@new_appointment.scheduling_method_radio_elements[0].enabled?).to eq(false)
      expect(@new_appointment.scheduling_method_radio_elements[1].enabled?).to eq(true)
      expect(@new_appointment.scheduling_method_radio_elements[1].selected?).to eq(true)
    end

    it "Add a Primary Care Request" do
      @new_appointment.cancelForm
      deletePatientData(@patientID)
      deletePatientData(@patientID2)
      restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
      @common.logoutAndLogbackWithADifferentUser(pw_redacted)
      @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)
      @common.waitWhileSpinnerPresent
      typeOfCare = PRIMARY_CARE
      schedulingMethod = "clerk"
      facilityId = "523"
      facilityName = "BOSTON HCS VAMC"
      typeOfVisit = "Office Visit"
      purposeOfVisit = "Medication Concern"
      otherPurposeOfVisit = ""
      desiredDateTime1 = [getDateNthDaysFromNow(40, "%m/%d/%Y"), "AM"]
      desiredDateTime2 = [getDateNthDaysFromNow(42, "%m/%d/%Y"), "PM"]
      desiredDAteTime3 = [getDateNthDaysFromNow(43, "%m/%d/%Y"), "AM"]
      phoneNum = "(234) 567-8901"
      verifyPhoneNum = "(234) 567-8901"

      bestTimeToCall = " Afternoon, Evening"
      call_morning = false
      call_afternoon = true
      call_evening = true
      bestTimesForVAtoCall = [call_morning, call_afternoon, call_evening]
      vaToCallYou = false
      message = ""
      sendMeEmail = "false"
      email = "test1@hotmail.com"

      addRequest(schedulingMethod, typeOfCare, facilityId, typeOfVisit, purposeOfVisit, otherPurposeOfVisit, desiredDateTime1, desiredDateTime2, desiredDAteTime3, phoneNum, verifyPhoneNum, bestTimesForVAtoCall, vaToCallYou, message, sendMeEmail, email)

      @common.waitWhileSpinnerPresent
      expect(@detail.back_btn_element.exists?).to eq(true)
    end

    it "Add another Primary Care request" do
      @detail.back_btn

      @common.waitWhileSpinnerPresent


      typeOfCare = PRIMARY_CARE
      schedulingMethod = "clerk"
      facilityId = "523"
      facilityName = "BOSTON HCS VAMC"
      typeOfVisit = "Phone Call"
      purposeOfVisit = "Medication Concern"
      otherPurposeOfVisit = ""
      desiredDateTime1 = [getDateNthDaysFromNow(32, "%m/%d/%Y"), "AM"]
      desiredDateTime2 = [getDateNthDaysFromNow(31, "%m/%d/%Y"), "PM"]
      desiredDAteTime3 = [getDateNthDaysFromNow(29, "%m/%d/%Y"), "AM"]
      phoneNum = "(234) 567-8901"
      verifyPhoneNum = "(234) 567-8901"

      bestTimeToCall = " Afternoon, Evening"
      call_morning = false
      call_afternoon = true
      call_evening = true
      bestTimesForVAtoCall = [call_morning, call_afternoon, call_evening]
      vaToCallYou = false
      message = ""
      sendMeEmail = "false"
      email = "test1@hotmail.com"

      addRequest(schedulingMethod, typeOfCare, facilityId, typeOfVisit, purposeOfVisit, otherPurposeOfVisit, desiredDateTime1, desiredDateTime2, desiredDAteTime3, phoneNum, verifyPhoneNum, bestTimesForVAtoCall, vaToCallYou, message, sendMeEmail, email)


      @common.waitWhileSpinnerPresent
      expect(@detail.back_btn_element.exists?).to eq(true)
    end

    it "Verify request limit message is displayed for Primary care" do

      @common.waitWhileSpinnerPresent
      @detail.back_btn_element.when_present(TIME_OUT_LIMIT)
      @detail.back_btn
      @common.waitWhileSpinnerPresent
      @common.selectAddAppointmentButton("VA")
      @new_request.selectTypeOfCare(PRIMARY_CARE)
      @new_request.selectState("523")
      @new_request.selectLocation("523")
      @common.waitWhileSpinnerPresent

      #max limit is 3 (customized)
      expected_content =[\
                        "Step 4: Scheduling Method",
                        "The location you selected supports the following scheduling methods:",
                        "* Select a scheduling method:",
                        "Schedule Myself",
                        "Submit a Request to VA Scheduler",
                        "You have reached the limit of 2 #{PRIMARY_CARE} request(s).",
                        "In order to proceed, please cancel a pending request, or wait for the VA to process a request."
      ]

      actual_content = @new_request.scheduling_method_section.split("\n")

      compareContents(expected_content, actual_content)


    end

    it "If a method is not available for the selected Type of Care, disable that choice and display informational text below the option that reads:" do
      @new_request.cancelForm
      restoreCollection("requestEligibilityCriteria", "var-utility", "audiologyRequestDisabled.json", @db)
      restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)
      @common.logoutAndLogbackWithADifferentUser(pw_redacted)
      @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)
      @common.waitWhileSpinnerPresent

      @common.selectAddAppointmentButton("VA")
      @common.waitWhileSpinnerPresent()
      @new_request.selectTypeOfCare(AUDIOLOGY)
      @new_request.selectState("523")
      @new_request.selectLocation("523")

      expected_content =[\
                        "Step 4: Scheduling Method",
                        "The location you selected supports the following scheduling methods:",
                        "* Select a scheduling method:",
                        "Schedule Myself",
                        "Submit a Request to VA Scheduler",
                        "This method is not available for the type of care you selected."
      ]
      actual_content = @new_request.scheduling_method_section.split("\n")
      compareContents(expected_content, actual_content)

    end

    it "Verify Request list displays the correct facility name on refresh" do
      @new_appointment.cancelForm
      restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
      typeOfCare = PRIMARY_CARE
      schedulingMethod = "clerk"
      facilityId = "523A5"
      facilityName = "BROCKTON VAMC"
      typeOfVisit = "Office Visit"
      purposeOfVisit = "Medication Concern"
      otherPurposeOfVisit = ""
      desiredDateTime1 = [getDateNthDaysFromNow(40, "%m/%d/%Y"), "AM"]
      desiredDateTime2 = [getDateNthDaysFromNow(42, "%m/%d/%Y"), "PM"]
      desiredDAteTime3 = [getDateNthDaysFromNow(43, "%m/%d/%Y"), "AM"]
      phoneNum = "(234) 567-8901"
      verifyPhoneNum = "(234) 567-8901"

      bestTimeToCall = " Afternoon, Evening"
      call_morning = false
      call_afternoon = true
      call_evening = true
      bestTimesForVAtoCall = [call_morning, call_afternoon, call_evening]
      vaToCallYou = false
      message = ""
      sendMeEmail = "false"
      email = "test1@hotmail.com"

      addRequest(schedulingMethod, typeOfCare, facilityId, typeOfVisit, purposeOfVisit, otherPurposeOfVisit, desiredDateTime1, desiredDateTime2, desiredDAteTime3, phoneNum, verifyPhoneNum, bestTimesForVAtoCall, vaToCallYou, message, sendMeEmail, email)
      @common.waitWhileSpinnerPresent
      @detail.back_btn_element.when_present(TIME_OUT_LIMIT)
      @detail.back_btn

      @common.waitWhileSpinnerPresent
      @landing_appointments.refresh
      @common.waitWhileSpinnerPresent
      request_details = @landing_appointments.request_table_list_elements[0]
      request_details.scroll.to :top
      Watir::Wait.until {@landing_appointments.getRequestTextForRowCol(2,2) == "Submitted"}
      expect(@landing_appointments.getRequestTextForRowCol(1,3)).to eq("BROCKTON VAMC")
      expect(@landing_appointments.getRequestTextForRowCol(2,3)).to eq("BOSTON HCS VAMC")
      expect(@landing_appointments.getRequestTextForRowCol(3,3)).to eq("BOSTON HCS VAMC")
    end

  end

end







































